-- Textweitergabe
    -- Übernahme Text aus Artikel
    --
    CREATE OR REPLACE FUNCTION TWawi.beleg_p__einkauf__from__txt__assign_art__jsonb(
        IN in_j_rec_einkauf jsonb
        )
        RETURNS jsonb
        AS $$
        DECLARE
          rec_einkauf TWawi.ldsdok_pos;
        BEGIN

           rec_einkauf := jsonb_populate_record( rec_einkauf, in_j_rec_einkauf );
           --
           IF COALESCE(rec_einkauf.p_code, 'E') = 'E' THEN
               SELECT txt, txtrtf
                 INTO rec_einkauf.p_txt_ext, rec_einkauf.p_txt_ext_rtf
                 FROM tartikel.adtx_getArtTxtLang( rec_einkauf.p_aknr, 'EK', rec_einkauf.p_adkrz, '' );
           END IF;

           SELECT ain_lagzu_txt, ain_lagzu_txt_rtf
             INTO rec_einkauf.p_txt_lagzu, rec_einkauf.p_txt_lagzu_rtf
             FROM ArtInfo
            WHERE ain_ak_nr = rec_einkauf.p_aknr;
           --
           RETURN to_jsonb( rec_einkauf );

        END $$ LANGUAGE plpgsql;

    -->               FUNCTION TWawi.beleg_p__einkauf__from__txt__assign_art(rec_einkauf jsonb) RETURNS TWawi.ldsdok_pos
    -- Übernahme aus Bestellvorschlag
    CREATE OR REPLACE FUNCTION TWawi.beleg_p__einkauf__from__txt__assign_bestvorschlag__jsonb(
        IN in_j_rec_einkauf jsonb,
        IN in_j_source_bv jsonb
        )
        RETURNS jsonb
        AS $$
        DECLARE
          rec_einkauf TWawi.ldsdok_pos;
          source_bv BestVorschlagPos;
        BEGIN

          rec_einkauf := jsonb_populate_record(rec_einkauf, in_j_rec_einkauf);

          --bug pg96 array in record
          IF ( tsystem.postgresqlversion() < 100 ) THEN
              in_j_source_bv := in_j_source_bv || '{"bvp_bedarf_list":null}'::jsonb;
          END IF;

          source_bv   := jsonb_populate_record( source_bv, in_j_source_bv );
          --
          rec_einkauf.p_txt_int     := coalesce( source_bv.bvp_txtint, rec_einkauf.p_txt_int );
          rec_einkauf.p_txt_int_rtf := coalesce( source_bv.bvp_txtint_rtf, rec_einkauf.p_txt_int_rtf );
          rec_einkauf.p_txt_ext     := coalesce( source_bv.bvp_txt, rec_einkauf.p_txt_ext );
          rec_einkauf.p_txt_ext_rtf := coalesce( source_bv.bvp_txt_rtf, rec_einkauf.p_txt_ext_rtf );

          RETURN to_jsonb( rec_einkauf );

        END $$ LANGUAGE plpgsql;


    -->               FUNCTION TWawi.beleg_p__einkauf__from__txt__assign(rec_einkauf TWawi.ldsdok_pos, source_bv BestVorschlagPos) RETURNS TWawi.ldsdok_pos
    --
    CREATE OR REPLACE FUNCTION TEinkauf.bestellvorschlag__generate__txt__from__bedarf_verursacher_list(
        IN  _bvp_bedarf_list tartikel.bedarf_verursacher[],
        OUT txt_ext text,
        OUT txt_ext_rtf text,
        OUT txt_int text,
        OUT txt_int_rtf text,
        OUT txt_lag text,
        OUT txt_lag_rtf text
        )
        RETURNS record
        AS $$
        DECLARE
          r record;
        BEGIN

          SELECT
              string_agg( DISTINCT bestanfpos.bap_txt, E'\n\n' ) AS txte,
              string_agg( DISTINCT bap_txtint, E'\n\n' ) AS txti,
              string_agg( DISTINCT bap_lagzu_txt, E'\n\n' ) AS txtl,
              --
              string_agg( DISTINCT bestanfpos.bap_txt_rtf, E'\n\n' ) AS txte_rtf,
              string_agg( DISTINCT bap_txtint_rtf, E'\n\n' ) AS txti_rtf,
              string_agg( DISTINCT bap_lagzu_txt_rtf, E'\n\n' ) AS txtl_rtf,
              --
              count(1)
          INTO r
          FROM unnest( _bvp_bedarf_list )
          LEFT JOIN bestanfpos ON bap_id = id
          WHERE type_index = 2; -- bestanfpos


          --
          txt_ext := r.txte;
          txt_int := r.txti;
          txt_lag := r.txtl;

          -- rtf addieren geht aktuell nicht. bei mehreren datensätzen fliegt rtf raus im aggregieren
          IF r.count = 1 THEN
              txt_ext_rtf := r.txte_rtf;
              txt_int_rtf := r.txti_rtf;
              txt_lag_rtf := r.txtl_rtf;
          END IF;
          --
          RETURN;

        END $$ LANGUAGE plpgsql;
--
    CREATE OR REPLACE FUNCTION TWawi.bestanfpos__from__auftgx__insert(
        IN _ag_id    integer,
        IN _bap_banr varchar
        )
        RETURNS      integer
        AS $$
        DECLARE
          _bap_id   integer;
          _bap_pos  integer;
        BEGIN
           -- BANF-Pos für Mehrmenge oder Zusatzinfo aus ABK-Materialposition oder Kundenauftrag anlegen.

          -- BANF-Kopf ggf. nachtragen
           IF NOT EXISTS(SELECT true FROM bestanftxt WHERE ba_nr = _bap_banr) THEN

              INSERT INTO bestanftxt ( ba_nr ) VALUES ( _bap_banr );

          END IF;

          -- nächste BANF-Pos ermitteln.
          _bap_pos := max( bap_pos ) FROM bestanfpos WHERE bap_banr = _bap_banr;
          _bap_pos := coalesce( _bap_pos, 0 ) + 1;

          -- BANF-Pos anlegen
            -- Menge 0: Die BANF-Pos repräsentiert eine Mehrmenge (vom Anwender zu editeren)
            -- oder eine Erweiterung der Daten (z.B Zusatzinfo wie Lieferant, welcher gewählt werden soll).
          INSERT INTO bestanfpos
                       ( bap_banr,  bap_pos,  bap_ag_id, bap_aknr, bap_akbez, bap_menge, bap_mecod, bap_termin,                       bap_agnr )
                SELECT   _bap_banr, _bap_pos, ag_id,      ag_aknr,  ag_akbz,   0,         m_mgcode,  coalesce( ag_ldatum, ag_kdatum ), ag_nr
          FROM auftg
            JOIN artmgc ON m_id = ag_mcv
          WHERE ag_id = _ag_id
          RETURNING bap_id
          INTO _bap_id
          ;

          RETURN _bap_id;
        END $$ LANGUAGE plpgsql;
  -- Einkauf : Datensatz erstellen, Bestellvorschlag
    -- Einkauf - Erzeugen Datensatz PLAIN / aus Artikel
    CREATE OR REPLACE FUNCTION TWawi.beleg_p__einkauf__create__from__plain_art__jsonb (
        IN _flags_enum      varchar,
        IN _code            varchar,
        IN _nummer          varchar,
        IN _pos             integer,
        IN _adkrz_lieferant varchar,
        IN _aknr            varchar,
        IN _akbez           varchar,
        IN _menge           numeric,
        IN _me              integer DEFAULT NULL,
        IN _los             numeric DEFAULT NULL,
        IN _adkrz_lieferadresse varchar DEFAULT '#'
        )
        RETURNS jsonb AS $$
        DECLARE
          rec_einkauf TWawi.Ldsdok_pos;
          rec_art     record;
          rec_adk2    adk2;
        BEGIN

          -- Initial & DEFAULTS: tables__fields__generate__defaults_values : TSystem.ENUM_GetValue(_flags_enum, 'DEFAULTS')
          IF TSystem.ENUM_GetValue(_flags_enum, 'DEFAULTS') THEN

              rec_einkauf := jsonb_populate_record(
                                rec_einkauf,
                                TSystem.tables__fields__generate__defaults_values( pg_typeof( rec_einkauf ) )
                             );
          END IF;
          --
          rec_einkauf.p_code        := _code;
          rec_einkauf.p_nummer      := _nummer;

          -- ldsdok__ld_pos__next
          IF _pos IS NULL THEN
              _pos := TWaWi.ldsdok__ld_pos__next( _code, _nummer );
          END IF;

          rec_einkauf.p_pos      := _pos;

          -- Artikeldaten, Kostenstelle usw.
          SELECT art.*, ac_ks, ac_konto, ain_lagzu_txt, ain_lagzu_txt_rtf 
            INTO rec_art
            FROM art
            JOIN artcod ON ak_ac = ac_n
            LEFT JOIN artinfo ON ain_ak_nr = ak_nr
           WHERE ak_nr = _aknr;

          -- Texte Einkauf / Lagerzugang
          rec_einkauf            := TWawi.beleg_p__einkauf__from__txt__assign_art( rec_einkauf );
          --
          rec_einkauf.p_aknr     := rec_art.ak_nr;
          -- Überschriebene Artikelbezeichnung: Vorgabeparameter in Funktion
          rec_einkauf.p_akbez    := _akbez;

          -- Verkauf => Einkauf : es wird aus dem Verkaufsauftrag die IDX übernommen und evtl nicht der aktuelle Default
          IF rec_einkauf.p_aknr_idx IS NULL THEN
              rec_einkauf.p_aknr_idx := rec_art.ak_idx;
          END IF;

          rec_einkauf.p_norm     := rec_art.ak_norm;

          -- Kostenstelle & Konto
          rec_einkauf.p_ks       := NullIf(Trim( coalesce( rec_art.ak_ks, rec_art.ac_ks) ), '');
          rec_einkauf.p_konto    := NullIf(Trim( coalesce( rec_art.ak_awko, rec_art.ac_konto) ), '');

          -- Mengen
          rec_einkauf.p_menge    := coalesce( _menge, rec_art.ak_verfueg * -1 );
          rec_einkauf.p_me       := coalesce( _me, tartikel.me__art__artmgc__m_id__by__ak_standard_mgc( rec_einkauf.p_aknr ) );
          rec_einkauf.p_los      := coalesce( _los, 0);

          -- Einlagerungshinweise
          rec_einkauf.p_txt_lagzu := rec_art.ain_lagzu_txt;
          rec_einkauf.p_txt_lagzu_rtf := rec_art.ain_lagzu_txt_rtf;

          --
          IF (
                 _code = 'I'
              OR (
                    rec_einkauf.p_los = 0
                AND TSystem.Settings__GetBool('lds_losgr_immer1')
              )
          ) THEN

              rec_einkauf.p_los   := 1;
          END IF;

          --
          IF rec_einkauf.p_los > 0 THEN
              rec_einkauf.p_menge := twawi.round_tolos( rec_einkauf.p_los, rec_einkauf.p_menge );
          END IF;

          -- Adressen
          rec_einkauf.p_adkrz    := coalesce(IFTHEN(_code = 'I', '#', NULL), _adkrz_lieferant);
          rec_einkauf.p_adkrzl   := _adkrz_lieferadresse;

          -- Steuern, adk2, Basis_W LagzuTxt usw.
          IF _code = 'E' THEN

              SELECT * INTO rec_adk2 FROM adk2 WHERE a2_krz = rec_einkauf.p_adkrz;
              --

              rec_einkauf.p_waer  := coalesce(rec_adk2.a2_waco, rec_einkauf.p_waer);

              -- Kurs durch Trigger
              rec_einkauf.p_scode :=
                coalesce(
                  rec_adk2.a2_wuco,
                  ( SELECT ain_steucode_ek FROM artinfo WHERE ain_ak_nr = rec_einkauf.p_aknr ),
                  TSystem.Settings__GetInteger( 'einksteucode' )
              );

              -- TODO: Folgendes Sollte durch Trigger (ist aber aktuell : 2019-09-10 - nicht)
              rec_einkauf.p_sproz := steu_proz FROM steutxt WHERE steu_z = rec_einkauf.p_scode;

          END IF;

          -- Todo Kontrollmerkmale (aktuell in Bestellvorschlag drin, von dort hierher übernehmen und Funktion draus machen siehe Bestellvorschlag)
          RETURN to_jsonb( rec_einkauf );

       END $$ LANGUAGE plpgsql;
    -->              FUNCTION TWawi.beleg_p__einkauf__create__from__plain_art() RETURNS TWawi.ldsdok_pos

    -- Bestellvorschlag => Einkauf - Erzeugen Datensatz aus Bestellvorschlag
    CREATE OR REPLACE FUNCTION TWawi.beleg_p__einkauf__create__from__bestellvorschlag__jsonb (
        IN _flags_enum varchar,
        --
        IN _code varchar,
        IN _nummer varchar,
        IN _pos integer,
        --
        IN _adkrz_lieferant varchar,
        IN _bvid integer,
        IN _adkrz_lieferadresse varchar = '#',
        --
        OUT out_rec_einkauf jsonb,
        OUT out_recs_abzu jsonb[],
        OUT out_recs_artPruefung jsonb[]
        )
        RETURNS record AS $$
        DECLARE
          rec_einkauf        TWawi.Ldsdok_pos;
          rec_bvp            BestVorschlagPos;
          preis              TWawi.Preis;
          preis_Extended     record;
          dolos              boolean;
          _artPruefung_aknrs varchar[];
          r                  record;

        BEGIN

          SELECT *
            INTO rec_bvp
            FROM BestVorschlagPos
           WHERE bvp_id = _bvid;

          dolos :=       bvs_dolos
                    FROM bestvorschlag
                   WHERE bvs_nr = rec_bvp.bvp_bvsnr;

          -- Grunddatensatz mit Menge und Artikel
          rec_einkauf :=
              -- Todo Übergabe Losgröße in Abhängigkeit bvs_dolos?
              TWawi.beleg_p__einkauf__create__from__plain_art(
                  _flags_enum, _code, _nummer, _pos,
                  --
                  coalesce( rec_bvp.bvp_lkn, _adkrz_lieferant ),
                  -- Artikelnummer und evtl überschriebene Artikelbezeichnung
                  rec_bvp.bvp_aknr, rec_bvp.bvp_ak_bez,
                  -- Mengen
                  rec_bvp.bvp_menge, rec_bvp.bvp_mcv,
                  ifthen( dolos, rec_bvp.bvp_eklos, null ),
                  _adkrz_lieferadresse
              );

          -- Bestellvorschlag: Texte, Divers
          rec_einkauf                  := TWawi.beleg_p__einkauf__from__txt__assign( rec_einkauf, rec_bvp );
          rec_einkauf.p_aknr_referenz  := rec_bvp.bvp_best; -- Übernahme Artikelreferenz

          -- Einlagerungshinweis, wenn nicht leer, dann überschreibt er den des Artikels
          IF coalesce( rec_bvp.bvp_txt_lag, '' ) <> '' THEN
            rec_einkauf.p_txt_lagzu := rec_bvp.bvp_txt_lag;
            rec_einkauf.p_txt_lagzu_rtf := rec_bvp.bvp_txt_lag_rtf;
          END IF;

          -- Preis
          preis                        := twawi.create_preis(rec_bvp.bvp_preis_table, rec_bvp.bvp_preis_dbrid);


          IF
              preis.source_table in ('anfangebot', 'anfangebotstaffel')
          THEN
              -- Übernahme Angebotsreferenz als Nr
              rec_einkauf.p_refnummer :=
                      alief_angnr
                                              FROM anfangebot
                                              JOIN anfLief ON aLief_id = aAng_aLief_id
                  LEFT JOIN epreisstaffel ON est_aang_id = aAng_id
                                              WHERE anfangebot.dbrid = preis.source_dbrid
                     OR epreisstaffel.dbrid = preis.source_dbrid;
          END IF;

          --Erweitern um Zusatzfelder: FolgeOpIx, Rahmendaten usw.
          SELECT *
            INTO preis_Extended
            FROM twawi.create_preis( preis.source_table, preis.source_dbrid )
            LEFT JOIN LATERAL (
                    SELECT *
                      FROM TWawi.GetPreisInfo( preis.source_table, preis.source_dbrid )
                  ) AS preisinfo ON true;

          -- Bestellvorschlag: Zuweisung Preissuche
          rec_einkauf.p_preis          := rec_bvp.bvp_preis;
          rec_einkauf.p_preiseinheit   := rec_bvp.bvp_preiseinheit;
          rec_einkauf.p_rabatt         := rec_bvp.bvp_rab;

          -- Bestellvorschlag: Datum
          rec_einkauf.p_datum_soll     := rec_bvp.bvp_ldatum;

          -- Wir selbst sind kein Rahmen, dann können wir ein Rahmenabruf sein => aus Quelle Einkauf

          -- Rahmen ld_rhl_nr
          IF
                      rec_einkauf.p_code <> 'R'
                  AND rec_einkauf.p_pos <> 0
                  AND preis.source_table = 'ldsdok'
          THEN
              --ld_rhl_nr
              rec_einkauf.p_rahmen_ident_concat  :=         ld_auftg || '/' || ld_pos
                                                       FROM ldsdok
                                                      WHERE ldsdok.dbrid = rec_bvp.bvp_preis_dbrid;
          END IF;

          -- Sonstiges (Folge_Op_Ix, Kostenstelle)
          rec_einkauf.p_folgeap_op_ix  := preis_Extended.folgeap_op_ix;
          rec_einkauf.p_ks             := NullIf( Trim(rec_bvp.bvp_ks), '');
          rec_einkauf.p_konto          := NullIf( Trim(rec_bvp.bvp_konto), '');

          -- Abzuschläge
          SELECT array_agg(to_jsonb(abzu))
            INTO out_recs_abzu
            FROM twawi.abzu__create__from__source__by__srctbl_dbrid( preis.source_table, preis.source_dbrid ) AS abzu;



          -- Kontrollmerkmale #8205 #7968 #7757 #8207 : für Artikel selbst sowie Übergeordneten Bedarfsverursacher (optional über flags gesteuert) => ACHTUNG: TEinkauf.anfrage_angebotZuBest identisch!!!!
          
          -- Artikel selbst plus Kopfartikel über Bestellvorschlag - Bedarfsverursacher - Parent

          SELECT _recs_artPruefung 
            INTO out_recs_artPruefung 
            FROM twawi.einkauf__artPruefung__create__from__bestellvorschlag__jsonb(rec_bvp.bvp_id) AS _recs_artPruefung;

          -- TODO Für Auswärtsvergaben das Arbeitspaket berücksichtigen. : TBest.PrepareArtPruefung ...
          -- Siehe Delphi Quellen. TBest.PrepareArtPruefung SELECT (tabk.abk__fertdata__by__a2_id(:ld_a2_id)).fertaknr
          -- Aktuell gibt es noch keinen Bestellvorschlag für Auswärtsbearbeitungen
          --
          out_rec_einkauf := to_jsonb( rec_einkauf );

          RETURN;

        END $$ LANGUAGE plpgsql;


    -- Bestellvorschlag => Einkauf INSERT: Einkauf - Bestellung aus Bestellvorschlag anlegen
    -- SELECT tsystem.function__drop_by_regex('beleg_p__einkauf__create__from__bestellvorschlag__insert', 'TWawi', false, true);
    CREATE OR REPLACE FUNCTION TWawi.beleg_p__einkauf__create__from__bestellvorschlag__insert(
        IN _flags_enum       varchar,
        IN _code             varchar,
        IN _nummer           varchar,
        IN _pos              integer,
        IN _adkrz_lieferant  varchar,
        IN _bvid             integer,
        IN _p_dokunr__create bool = true,
        IN _adkrz_lieferadresse varchar = TAdk.get_vorg_ladress('#')
        )
        RETURNS integer AS $$
        DECLARE
          rec               record;
          rec_einkauf       TWawi.Ldsdok_pos;
          rec_abzu          TWawi.View_All_Abzu;
          recs_abzu         TWawi.View_All_Abzu[];
          recs_artPruefung  artPruefung[];

        BEGIN

          SELECT *
            INTO rec
            FROM TWawi.beleg_p__einkauf__create__from__bestellvorschlag__jsonb(
                    TSystem.Enum_SetValue( _flags_enum, 'DEFAULTS' ),
                    _code,
                    _nummer,
                    _pos,
                    _adkrz_lieferant,
                    _bvid,
                    _adkrz_lieferadresse
          );

          --
          rec_einkauf := jsonb_populate_record( null::TWawi.Ldsdok_pos, rec.out_rec_einkauf );

          recs_abzu:= array_agg( jsonb_populate_record( null::TWawi.View_All_Abzu, x.out_recs_abzu ) )
                      FROM (
                         SELECT unnest AS out_recs_abzu FROM unnest( rec.out_recs_abzu )
                      ) AS x;

          recs_artPruefung  := array_agg( jsonb_populate_record( null::artPruefung, x.out_recs_artPruefung ) )
                               FROM (
                                  SELECT unnest AS out_recs_artPruefung FROM unnest( rec.out_recs_artPruefung )
                               ) AS x;

          -- Schon dokument vorhanden? Dann mitgeben oder erstellen
          IF _p_dokunr__create THEN
              rec_einkauf.p_dokunr :=
                  p_dokunr
                  FROM TWawi.Ldsdok_pos
                  WHERE
                        p_code = rec_einkauf.p_code
                    AND p_nummer = rec_einkauf.p_nummer
                    AND p_adkrz = rec_einkauf.p_adkrz
                  ORDER BY p_pos DESC
                  LIMIT 1
              ;

              IF rec_einkauf.p_dokunr IS NULL THEN

                 -- TODO bei Auswärts anderer Nummernkreis: ld_a2_id NOT NULL => SEQ=auswlog_aw_dokunr_seq TODO SQL Function
                 rec_einkauf.p_dokunr := nextval('ldsdok_ld_dokunr_seq');
              END IF;
          END IF;

          -- Einfügen in Tabelle Einkauf
          INSERT INTO twawi.ldsdok_pos
               SELECT (rec_einkauf).*
            RETURNING *
                 INTO rec_einkauf;

          -- Kontrollmerkmale anhängen
          FOR rec IN
            SELECT * FROM unnest(recs_artPruefung)
          LOOP
              INSERT INTO artpruefungtest
                     ( aprt_apr_id, aprt_ldid, aprt_pos, aprt_bez )
              VALUES ( rec.apr_id, rec_einkauf.p_id , rec.apr_pos, rec.apr_bez );
          END LOOP;

          -- Abzuschläge anhängen
          FOR rec_abzu IN
              SELECT * FROM unnest(recs_abzu)
          LOOP

              -- TODO rec_einkauf.p_menge_uf1?
              PERFORM TWawi.Abzu__Create__Insert(
                          rec_abzu,
                          'twawi.ldsdok_abzu',
                          rec_einkauf.p_id::VARCHAR,
                          rec_einkauf.p_menge
                      );
          END LOOP;

          -- Bestellnummer und Position zurückschreiben
          UPDATE bestvorschlagpos SET
                 bvp_einkauf_p_id      = rec_einkauf.p_id,
                 bvp_ldsduftg_dolink   = TSystem.ENUM_GetValue(_flags_enum, 'bvp_ldsduftg_dolink'),
                 bvp_ldatum            = rec_einkauf.p_datum_soll
           WHERE bvp_id                = _bvid;
          --
          -- BANF schliessen wenn nur Anfrage
          --
          RETURN rec_einkauf.p_id;

        END $$ LANGUAGE plpgsql;
  --

  -- Einkauf-Anfrage an Lieferant: aus Bestellvorschlag erstellen
    CREATE OR REPLACE FUNCTION TWawi.beleg_p__einkauf_anfpos__create_from__bestellvorschlag__jsonb(
        IN  _flags_enum varchar,
        IN  _nummer     varchar,
        IN  _bvid       integer,

        OUT out_rec_einkauf_anfpos jsonb
        )
        AS $$
        DECLARE
          rec_einkauf_anfpos    TWawi.einkauf_anfpos;
          rec_bvp               BestVorschlagPos;
        BEGIN

          SELECT *
            INTO rec_bvp
            FROM BestVorschlagPos
           WHERE bvp_id = _bvid;

          -- Initial & DEFAULTS: tables__fields__generate__defaults_values : TSystem.ENUM_GetValue(_flags_enum, 'DEFAULTS')
          IF TSystem.ENUM_GetValue(_flags_enum, 'DEFAULTS') THEN
              rec_einkauf_anfpos := jsonb_populate_record(rec_einkauf_anfpos, TSystem.tables__fields__generate__defaults_values(pg_typeof(rec_einkauf_anfpos)));
          END IF;
          --

          -- Anfrage für Auswärtsbearbeitung
          IF rec_bvp.bvp_typindex = 57 THEN
              -- Es muss Eindeutigkeit in der Arbeigsgangzuweisung bestehen,
              -- sonst logischer Fehler im Aggregat der Positionszusammenstellung im BV
              -- Wenn Anzahl der Gruppen! ungleich 1 ist.
              IF  NOT count(1) = 1
                  FROM (
                      SELECT count(1)
                        FROM ldsauftg JOIN bestanfpos ON la_bap_id = bap_id
                       WHERE la_bvp_id = _bvid
                       GROUP BY
                             bap_op_ix,
                             bap_o2_n,
                             bap_o2_id
                  ) AS c
              THEN
                  RAISE EXCEPTION 'unknown ldsauftg link';
              END IF;
              --

              SELECT bap_op_ix,
                     bap_o2_n,
                     bap_o2_id
                INTO rec_einkauf_anfpos.p_op_ix,
                     rec_einkauf_anfpos.p_o2_n,
                     rec_einkauf_anfpos.p_o2_id
                FROM bestanfpos
               WHERE bap_id = (SELECT la_bap_id
                                 FROM ldsauftg
                                WHERE la_bvp_id = _bvid
                                ORDER BY bap_id
                                 DESC LIMIT 1
                              )
              ;

          END IF;

          rec_einkauf_anfpos.p_k_nummer     := _nummer;
          rec_einkauf_anfpos.p_pos          := coalesce( ( SELECT max(p_pos) FROM TWawi.einkauf_anfpos WHERE p_k_nummer = _nummer ) + 1, 1 );
          rec_einkauf_anfpos.p_aknr         := rec_bvp.bvp_aknr;
          rec_einkauf_anfpos.p_akbez        := rec_bvp.bvp_ak_bez;
          rec_einkauf_anfpos.p_menge        := rec_bvp.bvp_menge;
          rec_einkauf_anfpos.p_me_mgcode    := rec_bvp.bvp_me_mgcode;
          rec_einkauf_anfpos.p_datum_soll   := rec_bvp.bvp_ldatum;
          rec_einkauf_anfpos.p_txt_ext      := rec_bvp.bvp_txt;
          rec_einkauf_anfpos.p_txt_ext_rtf  := rec_bvp.bvp_txt_rtf;
          rec_einkauf_anfpos.p_txt_int      := rec_bvp.bvp_txtint;
          rec_einkauf_anfpos.p_txt_int_rtf  := rec_bvp.bvp_txtint_rtf;
          --
          out_rec_einkauf_anfpos            := to_jsonb( rec_einkauf_anfpos );
          --
          RETURN;

        END $$ LANGUAGE plpgsql;
    --

    -- Anfrage => INSERT
    CREATE OR REPLACE FUNCTION TWawi.beleg_p__einkauf_anfpos__create_from__bestellvorschlag__insert(
        IN _flags_enum varchar,
        IN _nummer     varchar,
        IN _bvid       integer
        )
        RETURNS integer AS $$
        DECLARE
          rec         record;
          rec_einkauf_anfpos TWawi.einkauf_anfpos;
          lkn         varchar;
          agnr        varchar;
        BEGIN

          SELECT *
            INTO rec
            FROM TWawi.beleg_p__einkauf_anfpos__create_from__bestellvorschlag__jsonb(
                     TSystem.Enum_SetValue( _flags_enum, 'DEFAULTS' ),
                     _nummer,
                     _bvid
                 )
          ;

          rec_einkauf_anfpos     := jsonb_populate_record( NULL::TWawi.einkauf_anfpos, rec.out_rec_einkauf_anfpos );

          -- Kopfdaten aus Bestellvorschlag
          SELECT bvs_auftg, bvp_lkn
            INTO agnr, lkn
            FROM bestvorschlagpos JOIN bestvorschlag ON bvp_bvsnr = bvs_nr
           WHERE bvp_id = _bvid
          ;

          -- Anfrage Kopf anlegen, wenn nicht vorhanden
          IF NOT EXISTS (SELECT true FROM anfrage WHERE anf_nr = _nummer) THEN
              -- Kopfdatensatz Anfrage
              INSERT INTO anfrage (anf_nr, anf_agnr) VALUES (_nummer, agnr);
          END IF;

          -- prüfen ob in Bestellvorschlagpos bereits Lieferant angegeben, dann diesen direkt übernehmen
          IF lkn IS NOT NULL THEN
             IF NOT EXISTS (SELECT true FROM anflief WHERE alief_anf_nr = _nummer AND alief_lkn = lkn) THEN
                INSERT INTO anflief (alief_anf_nr, alief_lkn) VALUES (_nummer, lkn);
             END IF;
          END IF;

          -- Anfrage Position
          INSERT INTO TWawi.einkauf_anfpos
          SELECT (rec_einkauf_anfpos).*;

          UPDATE bestvorschlagpos
             SET bvp_aArt_id = rec_einkauf_anfpos.p_id,
                 bvp_ldsduftg_dolink = TSystem.ENUM_GetValue(_flags_enum, 'bvp_ldsduftg_dolink')
           WHERE bvp_id = _bvid;

          -- BANF verknüpfen, falls BSV aus BANF mit bap_anfrage
          UPDATE bestanfpos
             SET bap_aart_id = coalesce( bap_aart_id, rec_einkauf_anfpos.p_id ),

                 -- Wenn BANF nur zur Anfrage erstellt wurde, dann ist die BANF mit der Anfrage auch erledigt
                 bap_done    = IFTHEN(bap_anfrage, True, bap_done)

           WHERE
                -- alle BANFen die unter der BSV-Pos lagen
                bap_id IN (
                    SELECT la_bap_id FROM ldsauftg WHERE la_bvp_id = _bvid
                );
          --
          RETURN rec_einkauf_anfpos.p_id;
          --
        END $$ LANGUAGE plpgsql;
  --
